///////////////////////////////////////////////////////////////////////////////
//
// File: LibUtilities.cpp
//
// For more information, please see: http://www.nektar.info
//
// The MIT License
//
// Copyright (c) 2006 Division of Applied Mathematics, Brown University (USA),
// Department of Aeronautics, Imperial College London (UK), and Scientific
// Computing and Imaging Institute, University of Utah (USA).
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//
// Description: Python wrapper for LibUtilities classes.
//
///////////////////////////////////////////////////////////////////////////////

#include <sstream>

#include <LibUtilities/BasicUtils/ErrorUtil.hpp>

#include <LibUtilities/Python/NekPyConfig.hpp>

void export_Basis(py::module &);
void export_Comm(py::module &);
void export_Interpreter(py::module &);
void export_Equation(py::module &);
void export_Points(py::module &);
void export_SessionReader(py::module &);
void export_ShapeType(py::module &);
void export_TimeIntegrationScheme(py::module &);
void export_TimeIntegrationSchemeOperators(py::module &);

// Stringstream to accumulate errors generated by exceptions.
std::stringstream errorStream;

using NekError = Nektar::ErrorUtil::NekError;

PYBIND11_MODULE(_LibUtilities, m)
{
    // Register the NekError exception.
    py::register_exception<NekError>(m, "NekError");

    // Set a stringstream as an error sink to avoid duplicate output.
    Nektar::ErrorUtil::SetErrorStream(errorStream);

    export_Basis(m);
    export_Comm(m);
    export_Equation(m);
    export_Interpreter(m);
    export_Points(m);
    export_SessionReader(m);
    export_ShapeType(m);
    export_TimeIntegrationScheme(m);
    export_TimeIntegrationSchemeOperators(m);
}
